<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Mtc\ContentManager\Models\MediaSize;

class MediaSizeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($size) => MediaSize::query()->updateOrCreate($size));
    }

    private function data(): array
    {
        return [
            [
                'width' => 2560,
                'height' => 650,
                'label' => 'full-width-banner',
                'model' => 'dealership',
            ],
            [
                'width' => 2560,
                'height' => 650,
                'label' => 'full-width-banner',
                'model' => 'dealership-content',
            ],
            [
                'width' => 450,
                'height' => 450,
                'label' => 'square-tile',
                'model' => 'dealership-content',
            ],
            [
                'width' => 250,
                'height' => 250,
                'label' => 'square-tile',
                'model' => 'menu_entry',
            ],
            [
                'width' => 325,
                'height' => 250,
                'label' => 'tile',
                'model' => 'vehicle',
            ],
            [
                'width' => 440,
                'height' => 295,
                'label' => 'medium',
                'model' => 'vehicle',
            ],
            [
                'width' => 900,
                'height' => 600,
                'label' => 'large',
                'model' => 'vehicle',
            ],
            [
                'width' => 375,
                'height' => 250,
                'label' => 'tile',
                'model' => 'offer',
            ],
            [
                'width' => 440,
                'height' => 295,
                'label' => 'medium',
                'model' => 'offer',
            ],
            [
                'width' => 900,
                'height' => 600,
                'label' => 'large',
                'model' => 'offer',
            ],
            [
                'width' => 325,
                'height' => 250,
                'label' => 'tile',
                'model' => 'new-car',
            ],
            [
                'width' => 2560,
                'height' => 650,
                'label' => 'full-width-banner',
                'model' => 'new-car',
            ],
            [
                'width' => 2560,
                'height' => 650,
                'label' => 'full-width-banner',
                'model' => 'new-car',
            ],
            [
                'width' => 2560,
                'height' => 650,
                'label' => 'full-width-banner',
                'model' => 'content',
            ],
            [
                'width' => 680,
                'height' => 680,
                'label' => 'side-by-side-cta',
                'model' => 'content',
            ],
            [
                'width' => 680,
                'height' => 330,
                'label' => 'stacked-cta',
                'model' => 'content',
            ],
            [
                'width' => 800,
                'height' => 550,
                'label' => 'image-besides-text',
                'model' => 'content',
            ],
            [
                'width' => 1600,
                'height' => 900,
                'label' => 'full-width-image-16-9',
                'model' => 'content',
            ],
            [
                'width' => 450,
                'height' => 450,
                'label' => 'square-tile',
                'model' => 'content',
            ],
            [
                'width' => 2560,
                'height' => 650,
                'label' => 'full-width-banner',
                'model' => 'new-car-content',
            ],
            [
                'width' => 680,
                'height' => 680,
                'label' => 'side-by-side-cta',
                'model' => 'new-car-content',
            ],
            [
                'width' => 680,
                'height' => 330,
                'label' => 'stacked-cta',
                'model' => 'new-car-content',
            ],
            [
                'width' => 800,
                'height' => 550,
                'label' => 'image-besides-text',
                'model' => 'new-car-content',
            ],
            [
                'width' => 1600,
                'height' => 900,
                'label' => 'full-width-image-16-9',
                'model' => 'new-car-content',
            ],
            [
                'width' => 450,
                'height' => 450,
                'label' => 'square-tile',
                'model' => 'new-car-content',
            ],
            [
                'width' => 2560,
                'height' => 650,
                'label' => 'full-width-banner',
                'model' => 'offer-content',
            ],
            [
                'width' => 680,
                'height' => 680,
                'label' => 'side-by-side-cta',
                'model' => 'offer-content',
            ],
            [
                'width' => 680,
                'height' => 330,
                'label' => 'stacked-cta',
                'model' => 'offer-content',
            ],
            [
                'width' => 800,
                'height' => 550,
                'label' => 'image-besides-text',
                'model' => 'offer-content',
            ],
            [
                'width' => 1600,
                'height' => 900,
                'label' => 'full-width-image-16-9',
                'model' => 'offer-content',
            ],
            [
                'width' => 450,
                'height' => 450,
                'label' => 'square-tile',
                'model' => 'offer-content',
            ],
            [
                'width' => 332,
                'height' => 332,
                'label' => 'square-tile',
                'model' => 'page',
            ],
        ];
    }
}
