<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class LogExpirySettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Storage',
                'name' => 'Api notification log expiry',
                'config_key' => 'app-log-expiry-days',
                'type' => 'int',
                'value' => 0,
                'superadmin' => true,
                'description' => 'Length (days) how long we keep logs. System default is 30 days. 0 uses system default',
                'order' => 1,
            ],
        ];
    }
}
