<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class KeyloopLeasingHybridFuelHintOptionCodeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Leasing',
                'group' => 'Keyloop Fleet Kompact',
                'name' => 'Hybrid fuel hint option code',
                'description' => 'Option code for the spec option that can help match a "Hybrid" fuel type to e.g. "Petrol Hybrid"',
                'config_key' => 'leasing-keyloop-fleet-kompact-hybrid-fuel-hint-option-code',
                'type' => 'string',
                'value' => '8701',
            ],
        ];
    }
}
