<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class KeyloopFleetKompactSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Leasing',
                'group' => 'Keyloop Fleet Kompact',
                'name' => 'Enabled',
                'config_key' => 'leasing-keyloop-fleet-kompact-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Leasing',
                'group' => 'Keyloop Fleet Kompact',
                'name' => 'FTP Username',
                'config_key' => 'leasing-keyloop-fleet-kompact-ftp-username',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.leasing-keyloop-fleet-kompact-enabled,true"
                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Leasing',
                'group' => 'Keyloop Fleet Kompact',
                'name' => 'FTP Password',
                'config_key' => 'leasing-keyloop-fleet-kompact-ftp-password',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.leasing-keyloop-fleet-kompact-enabled,true"
                ],
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => __('features.imagin_placeholders.title'),
                'name' => 'Lease Vehicle',
                'config_key' => 'imagin-placeholders-lease-vehicle-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Leasing',
                'group' => 'Keyloop Fleet Kompact',
                'name' => 'Provider Type',
                'description' => 'Selects provider-specific behaviour, such as finance calculations. This value is case insensitive.',
                'config_key' => 'leasing-keyloop-fleet-kompact-provider-type',
                'type' => 'string',
                'value' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Leasing',
                'group' => 'Keyloop Fleet Kompact',
                'name' => 'VAT percentage in decimal',
                'description' => 'For use in finance calculations. Decimal representation of a percentage. 7% should be entered as 0.07',
                'config_key' => 'leasing-keyloop-fleet-kompact-vat-rate',
                'type' => 'number',
                'value' => null,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Leasing',
                'group' => 'Keyloop Fleet Kompact',
                'name' => 'Interest rate percentage in decimal',
                'description' => 'For use in finance calculations. Decimal representation of a percentage. 7% should be entered as 0.07',
                'config_key' => 'leasing-keyloop-fleet-kompact-interest-rate',
                'type' => 'number',
                'value' => null,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Leasing',
                'group' => 'Keyloop Fleet Kompact',
                'name' => 'Delivery Price',
                'config_key' => 'leasing-keyloop-fleet-kompact-delivery-price',
                'type' => 'number',
                'value' => null,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Cheapest Lease Variant (Required for Keyloop Fleet Kompact)',
                'config_key' => 'automotive-vehicle-filters-cheapest_lease_variant',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Leasing',
                'group' => 'General',
                'name' => 'Lease Vehicle URL structure',
                'config_key' => 'automotive-lease-vehicles-url_building_format',
                'type' => 'string',
                'value' => 'make-model',
                'description' => 'Format used for vehicle stock links on website',
                'choices' => [
                    ['value' => 'make-model', 'name' => 'Generated as VRM-Make-Model'],
                    ['value' => 'title', 'name' => 'Title converted to URL'],
                    ['value' => 'uuid', 'name' => 'External ID converted to URL'],

                ],
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Lease Vehicle Sorting',
                'name' => 'New Additions',
                'config_key' => 'automotive-vehicle-sorting-latest',
                'type' => 'boolean',
                'value' => false,
                'order' => 1,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Lease Vehicle Sorting',
                'name' => 'Price (Low > High)',
                'config_key' => 'automotive-vehicle-sorting-lease-vehicle-price-asc',
                'type' => 'boolean',
                'value' => false,
                'order' => 1,
            ],

            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Lease Vehicle Sorting',
                'name' => 'Price (High > Low)',
                'config_key' => 'automotive-vehicle-sorting-lease-vehicle-price-desc',
                'type' => 'boolean',
                'value' => false,
                'order' => 1,
            ],

            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Lease Vehicle Sorting',
                'name' => 'Monthly Price (Low > High)',
                'config_key' => 'automotive-vehicle-sorting-lease-vehicle-monthly-price-asc',
                'type' => 'boolean',
                'value' => false,
                'order' => 1,
            ],

            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Lease Vehicle Sorting',
                'name' => 'Monthly Price (High > Low)',
                'config_key' => 'automotive-vehicle-sorting-lease-vehicle-monthly-price-desc',
                'type' => 'boolean',
                'value' => false,
                'order' => 1,
            ],
        ];
    }
}
