<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class InjectOffersIntoUsedCarFilterSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Inject offers into used car filter',
                'config_key' => 'filter-inject-offers-into-used-car-filter',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'order' => 7,
            ],
        ];
    }
}
