<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ImaginStudioClientKeySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => __('features.imagin_placeholders.title'),
                'name' => 'Client Billing Key',
                'config_key' => 'imagin-placeholders-client-key',
                'value' => '',
                'type' => 'string',
            ]
        ];
    }
}
