<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class FinanceProductRestrictionSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Restrict retrieved rates to specific product',
                'config_key' => 'finance-restricted-product-type',
                'type' => 'string',
                'value' => '',
                'order' => 11,
                'description' => 'HP or PCP as value when wanting to restrict to a specific product when fetching rates',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Batch update rates',
                'config_key' => 'finance-batch-update',
                'type' => 'boolean',
                'value' => false,
                'order' => 10,
                'description' => 'Update rates in batches automatically once per day',
            ],
        ];
    }
}
