<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FinanceCalculatorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Load finance calculator for vehicle listing',
                'config_key' => 'vehicle-list-load-finance-calculator',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Load finance calcualator on each vehicle list on the results page',
                'order' => 1,
            ],
        ];
    }
}
