<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FilterUseReplacementsOnSearchTermsSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Use replacements to amend search terms',
                'config_key' => 'filter-apply-replacements-to-search-terms',
                'type' => 'boolean',
                'value' => false,
                'description' => 'e.g. pick up to pickup',
                'order' => 20,
            ],
        ];
    }
}
