<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FilterFinanceExampleTypeSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Finance example type',
                'config_key' => 'filter-finance-example-type',
                'type' => 'string',
                'value' => 'any',
                'description' => 'Set a specific type of finance product type for default example on search result page',
                'choices' => [
                    ['value' => 'any', 'name' => 'Any'],
                    ['value' => 'HP', 'name' => 'HP'],
                    ['value' => 'PCP', 'name' => 'PCP'],
                    ['value' => 'CS', 'name' => 'CS'],
                    ['value' => 'LP', 'name' => 'LP'],
                ],
                'order' => 99,
            ],
        ];
    }
}
