<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FeaturesOnOfferListSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'General',
            'group' => 'Offers',
            'name' => 'Include Features in Offers List',
            'config_key' => 'offer-list-load-features',
            'type' => 'boolean',
            'value' => false,
            'superadmin' => true,
            'min_tier' => 'pro',
            'description' => 'Enable loading features for offer lists such as browse or cross-sell offers.<br/>',
            'order' => 20,
        ]);
    }
}
