<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FPADefaultFormSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Vehicle page enquiry form',
                'config_key' => 'vehicle-fpa-form-id',
                'type' => 'string',
                'value' => null,
                'source' => 'forms',
            ],
            // We also want to re-seed settings with endpoints for sources to have source value
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Blog',
                'name' => 'Blog article default template',
                'config_key' => 'app-content-blog-default-template',
                'type' => 'string',
                'source' => 'templates',
                'description' => 'Select template which should be set as default when creating blog articles',
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'News',
                'name' => 'News article default template',
                'config_key' => 'app-content-news-default-template',
                'type' => 'string',
                'source' => 'templates',
                'description' => 'Select template which should be set as default when creating news articles',
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Country',
                'config_key' => 'app-details-country',
                'type' => 'string',
                'source' => 'countries',
                'validation_rules' => 'required',
                'description' => 'Primary country of operation as Alpha-2 code (e.g. GB/IE/DE)',
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Site Currency',
                'config_key' => 'app-details-currency',
                'type' => 'string',
                'source' => 'currencies',
                'validation_rules' => 'required',
                'description' => 'Primary Currency used for the site',
            ],
        ];
    }
}
