<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class EnquiryMaxSendReservation extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'enquiryMax',
                'name' => 'Send Reservations to EnquiryMax',
                'config_key' => 'crm-enquiry-max-send-reservations',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => 'Send reservations to EnquiryMax',
            ],
        ];
    }
}
