<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class EnquiryMaxClosestDealerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'enquiryMax',
                'name' => 'Send Enquiries to closest dealer',
                'config_key' => 'crm-enquiry-max-closest-dealer',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => 'Send enquiries to the dealership closest to the submitted postcode',
            ],
        ];
    }
}
