<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class EasichatSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'EasiChat',
                'name' => 'Enabled',
                'config_key' => 'easi-chat-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => '<a href="https://easichat.co.uk/" target="_blank">EasiChat</a> integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'EasiChat',
                'name' => 'Client ID',
                'config_key' => 'easi-chat-client_id',
                'type' => 'string',
                'value' => '',
                'order' => 1,
                'validation_rules' => [
                    "required_if:values.easi-chat-enabled,true"
                ]
            ],
        ];
    }
}
