<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class DealershipsUrlPathSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Dealerships',
                'name' => 'Dealership page URL path',
                'config_key' => 'dealerships-url-path',
                'type' => 'string',
                'value' => '/locations/',
                'order' => 1,
                'min_tier' => 'enterprise',
                'description' => 'path - e.g. /locations/ '
                    . 'Used for URL generating in API, must match the implementation in theme!',
            ],
        ];
    }
}
