<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class DealershipWhatsappSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Dealerships',
                'name' => 'Dealership WhatsApp Enabled',
                'config_key' => 'dealerships-whatsapp-enabled',
                'type' => 'boolean',
                'value' => false,
            ]
        ];
    }
}
