<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class DealershipSortOrderSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Dealerships',
                'name' => 'Sort Order',
                'config_key' => 'dealerships-sort-order',
                'type' => 'string',
                'value' => 'name',
                'description' => 'How dealerships should be sorted on the frontend',
                'choices' => [
                    ['value' => 'name', 'name' => 'Alphabetically by name'],
                    ['value' => 'order', 'name' => 'Manual order'],
                ],
                'order' => 99,
            ],
        ];
    }
}
