<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class DealerWebLmsSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Dealer Web LMS',
                'name' => 'Enabled',
                'config_key' => 'dealerweblms-crm-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => '<a href="https://www.dealerweb.org/" target="_blank">DealerWeb LMS</a> lead management integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Dealer Web LMS',
                'name' => 'LMS Username',
                'config_key' => 'dealerweblms-lms-username',
                'type' => 'string',
                'value' => '',
                'description' => 'The username for Dealer Web LMS integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Dealer Web LMS',
                'name' => 'DealerID/DealerNo',
                'config_key' => 'dealerweblms-dealerid',
                'type' => 'string',
                'value' => '',
                'description' => 'The Dealer ID or Dealer Number used for integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Dealer Web LMS',
                'name' => 'Password',
                'config_key' => 'dealerweblms-password',
                'type' => 'string',
                'value' => '',
                'description' => 'The password for Dealer Web LMS integration.'
            ],
        ];
    }
}
