<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class DMSNavigatorSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'DMS Navigator',
                'name' => 'Enabled',
                'config_key' => 'stock-dms-navigator-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => '<a href="https://www.dmsnavigator.com/" target="_blank">DMS Navigator</a> sync integration.',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'DMS Navigator',
                'name' => 'Synchronize images',
                'config_key' => 'stock-dms-navigator-sync-images',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
                'description' => 'Retrieve images from DMS and add them to vehicles when importing'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'DMS Navigator',
                'name' => 'Only "Available for Sale" vehicles',
                'config_key' => 'stock-dms-navigator-sync-only-available-for-sale',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'DMS Navigator',
                'name' => 'Only "Advertise on Own Web Site" vehicles',
                'config_key' => 'stock-dms-navigator-sync-only-for-website',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'DMS Navigator',
                'name' => 'Only marked as "Export" vehicles',
                'config_key' => 'stock-dms-navigator-sync-only-export',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'DMS Navigator',
                'name' => 'API Key',
                'config_key' => 'stock-dms-navigator-api-key',
                'type' => 'secret',
                'min_tier' => 'standard',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.stock-dms-navigator-enabled,true"
                ]
            ],
        ];
    }
}
