<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CustomFileSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Remote custom file',
                'name' => 'Enabled',
                'config_key' => 'stock-file-enabled',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
                'order' => 1,
                'description' => 'Retrieve data from a remote file location and import using an <a href="/settings/import-maps">import map</a>',
            ],
        ];
    }
}
