<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CodeWeaversActionSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'CodeWeavers',
                'name' => 'Show "Reserve now for XX" button',
                'config_key' => 'sales-codeweavers-reserve',
                'type' => 'boolean',
                'value' => true,
                'order' => 10,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'CodeWeavers',
                'name' => 'Reserve button text',
                'config_key' => 'sales-codeweavers-reserve-button-text',
                'type' => 'string',
                'value' => 'Reserve for £99',
                'order' => 11,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'CodeWeavers',
                'name' => 'Show "Build a deal" button',
                'config_key' => 'sales-codeweavers-build-deal',
                'type' => 'boolean',
                'value' => true,
                'order' => 12,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales',
                'group' => 'CodeWeavers',
                'name' => 'Build your deal button text',
                'config_key' => 'sales-codeweavers-deal-button-text',
                'type' => 'string',
                'value' => 'Build your deal',
                'order' => 13,
            ],
        ];
    }
}
