<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CarzoneSoldReservedStockSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Carzone',
                'name' => 'Remove vehicles from Carzone when status changes to Sold',
                'config_key' => 'automotive-sales-channels-carzone-remove-sold',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Carzone',
                'name' => 'Remove vehicles from Carzone when status changes to Reserved',
                'config_key' => 'automotive-sales-channels-carzone-remove-reserved',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
