<?php

namespace Database\Seeders\Tenant;

class BookTestDriveNewSeeder extends GeneralEnquirySeeder
{
    public function run()
    {
        $this->createForm('Book a Test Drive - New Vehicle', 'Test Drive', [
            [
                'name' => 'Date',
                'type' => 'date_field',
                'is_active' => 1,
                'validation' => ['required', 'date']
            ],
            [
                'name' => 'Preferred Time of Day',
                'type' => 'checkbox_list',
                'is_active' => 1,
                'validation' => ['required'],
                'data' => [
                    'component' => 'CheckboxList',
                    'componentName' => 'CheckboxList',
                    'meta' => [
                        'content' => 'Anytime:Anytime
Morning:Morning
Afternoon:Afternoon
Evening:Evening',
                        'options' => [
                            'items' => [
                                ['name' => 'Anytime', 'value' => 'Anytime'],
                                ['name' => 'Morning', 'value' => 'Morning'],
                                ['name' => 'Afternoon', 'value' => 'Afternoon'],
                                ['name' => 'Evening', 'value' => 'Evening'],
                            ]
                        ]
                    ]
                ]
            ],
            [
                'name' => 'New car item/id',
                'type' => 'text_field',
                'is_active' => 1,
                'validation' => ['required']
            ]
        ]);
    }
}
