<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class BodyTypeOverrideSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Taxonomies',
                'name' => 'Body Style vehicle type override: SUV',
                'config_key' => 'body-type-vehicle-type-override-suv',
                'type' => 'string',
                'choices' => [
                    ['value' => '', 'name' => 'Default'],
                    ['value' => 'car', 'name' => 'Car'],
                    ['value' => 'lcv', 'name' => 'LCV'],
                ],
                'value' => '',
                'description' => 'Allows the body style taxonomy vehicle type to be overriden. If SUV is linked to LCVs, we can override to car.'
                    . ' Set to "Default" to use default mapped taxonomy vehicle type',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Taxonomies',
                'name' => 'Body Style vehicle type override: MPV',
                'config_key' => 'body-type-vehicle-type-override-mpv',
                'type' => 'string',
                'choices' => [
                    ['value' => '', 'name' => 'Default'],
                    ['value' => 'car', 'name' => 'Car'],
                    ['value' => 'lcv', 'name' => 'LCV'],
                ],
                'value' => '',
                'description' => 'Allows the body style taxonomy vehicle type to be overriden. If MPV is linked to Cars, we can override to LCV.'
                    . ' Set to "Default" to use default mapped taxonomy vehicle type',
            ],
        ];
    }
}
