<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class BcaLocationIdSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'BCA',
                'name' => 'Location in DealerPro',
                'config_key' => 'valuation-bca-location-id',
                'type' => 'boolean',
                'value' => '',
                'description' => 'Location ID in DealerPro to allow exporting valuations'
            ],
        ];
    }
}
