<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AutosOnShowImageCountSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'AutosOnShow',
                'name' => 'Max number of images per vehicle',
                'config_key' => 'autos-on-show-image-limit',
                'type' => 'int',
                'value' => 99,
                'description' => 'Number of images to import per vehicle. Set to 1 if using AoS widget'
            ],
        ];
    }
}
