<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderUpsertCoDriverSettings extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Generate Description (Co-Driver AI)',
                'config_key' => 'auto-trader-upsert-generate-description',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Generates a vehicle description automatically if it is missing or longer '
                    . 'than 4000 characters.',
                'order' => 30,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Sort Images (Co-Driver AI)',
                'config_key' => 'auto-trader-upsert-sort-images',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Automatically sort images using Smart Image Management logic.',
                'order' => 31,
            ],
        ];
    }
}
