<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderStockVatSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock pull from AutoTrader to website',
                'name' => 'Vat status calculation',
                'config_key' => 'auto-trader-stock-vat-calculation',
                'type' => 'string',
                'value' => 'vat-status',
                'choices' => [
                    ['value' => 'vat-status', 'name' => 'Based on VAT status field'],
                    ['value' => 'vat-and-type', 'name' => 'Based on VAT status and vehicle type fields'],
                ],
                'description' => 'Vat status copies same value as on AutoTrader, Vat Status and Type '
                    . 'sets as applicable for when Car with Inc Vat or LCV with Ex Vat'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Publish new car stock',
                'config_key' => 'auto-trader-connect-publish-new-cars',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Specify if new car stock should automatically be marked to publish on AutoTrader',
            ],
        ];
    }
}
