<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AutoTraderStockSyncVideoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock pull from AutoTrader to website',
                'name' => 'Synchronize Video',
                'config_key' => 'stock-auto-trader-sync-video',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
                'description' => 'Set video url from AutoTrader value (may conflict with other video providers)',
                'order' => 33
            ],
        ];
    }
}
