<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderRemoveImagesSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Remove vehicles images from AutoTrader feed',
                'config_key' => 'auto-trader-stock-remove-vehicles-images',
                'type' => 'boolean',
                'value' => false,
                'description' => '.',
                'order' => 22,
            ],
        ];
    }
}
