<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderLabelForLCVCarsSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Override LCV label',
                'config_key' => 'auto-trader-stock-override-lcv-label',
                'type' => 'string',
                'value' => 'LCV',
                'description' => '',
                'order' => 22,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Override CARS label',
                'config_key' => 'auto-trader-stock-override-cars-label',
                'type' => 'string',
                'value' => 'CARS',
                'description' => '',
                'order' => 22,
            ],
        ];
    }
}
