<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderKeyFeatureSyncFlags extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock pull from AutoTrader to website',
                'name' => 'Sync selected standard key features',
                'config_key' => 'autotrader-stock-sync-standard-key-features',
                'type' => 'boolean',
                'value' => true,
                'order' => 24,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock pull from AutoTrader to website',
                'name' => 'Sync selected optional key features',
                'config_key' => 'autotrader-stock-sync-optional-key-features',
                'type' => 'boolean',
                'value' => true,
                'order' => 25,
            ],
        ];
    }
}
