<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderCsvExportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Feed Type',
                'config_key' => 'sales-channels-auto-trader-method',
                'type' => 'string',
                'superadmin' => true,
                'choices' => [
                    ['value' => 'ftp', 'name' => 'FTP'],
                    ['value' => 'api', 'name' => 'API'],
                ],
                'value' => 'api',
                'order' => 10
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'FTP feed file name',
                'config_key' => 'sales-channels-auto-trader-file-name',
                'type' => 'string',
                'value' => '',
                'superadmin' => true,
            ],
        ];
    }
}
