<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AutoImagingSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        $description = '<a href="https://www.autoimaging.co.uk/" target="_blank">AutoImaging</a> integration '
            . '- allows receiving notifications with vehicle images to site.'
            . 'When enabled, will grant access to URL for handling images:<br/>'
            . 'GET ' . route('tenant.notifications.auto-imaging.index', tenant('id')) . ' to list current vehicles on site<br/>'
            . 'POST ' . route('tenant.notifications.auto-imaging.store', tenant('id')) . ' to receive and store images from AutoImaging';
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'AutoImaging',
                'name' => 'Enabled',
                'config_key' => 'image-sync-auto-imaging-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => $description
            ],
        ];
    }
}
