<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AlternateOpenThirdTimesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Dealerships',
                'name' => 'Tertiary open/close times',
                'config_key' => 'dealership-third-open-times',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Enables third open/close time windows per dealership',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Dealerships',
                'name' => 'Tertiary open/close time name',
                'config_key' => 'dealership-tertiary-open-close-time-name',
                'type' => 'string',
                'value' => '',
                'description' => 'Descriptive name - e.g. aftersales',
            ],
        ];
    }
}
