<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AaCarsExportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'AaCars',
                'name' => 'Enabled',
                'config_key' => 'sales-channels-aa-cars-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'AaCars',
                'name' => 'FTP server Username',
                'config_key' => 'sales-channels-aa-cars-ftp-username',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-aa-cars-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'AaCars',
                'name' => 'FTP server Password',
                'config_key' => 'sales-channels-aa-cars-ftp-password',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-aa-cars-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'AaCars',
                'name' => 'Vehicle export file name',
                'config_key' => 'sales-channels-aa-cars-file-name',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-aa-cars-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'AaCars',
                'name' => 'Dealership export file name',
                'config_key' => 'sales-channels-aa-cars-dealership-file-name',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-aa-cars-enabled,true"
                ]
            ],
        ];
    }
}
