<?php

namespace Database\Seeders\MercuryTheme;

use Illuminate\Database\Seeder;
use Mtc\ContentManager\Models\Template;
use Mtc\MercuryDataModels\OfferType;

class OfferTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        OfferType::query()->truncate();
        collect($this->getList())
            ->each(function ($entry) {
                $offerType = new OfferType();
                $offerType->fill($entry);
                $offerType->slug = $entry['slug'];
                $offerType->save();
            });
    }

    public function getList()
    {
        return [
            [
                'name' => 'New vehicle offer',
                'slug' => 'new',
                'template_id' => Template::query()->where('slug', 'new-vehicle-offer')->first()?->id,
            ],
            [
                'name' => 'Motability offer',
                'slug' => 'motability',
                'template_id' => Template::query()->where('slug', 'motability-offer')->first()?->id,
            ],
            [
                'name' => 'EV offer',
                'slug' => 'ev',
                'template_id' => Template::query()->where('slug', 'ev-offer')->first()?->id,
            ],
        ];
    }

}
