<?php

namespace Database\Seeders\Global;

use App\Master\Models\VehicleMake;
use Illuminate\Database\Seeder;
use App\Master\Models\BodyStyleType;
use App\Master\Models\DrivetrainType;
use App\Master\Models\FuelType;
use App\Master\Models\TransmissionType;
use Illuminate\Support\Facades\File;

class VehicleTaxonomySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->makesAndModels();
        $this->fuelTypes();
        $this->transmissions();
        $this->bodyStyles();
        $this->drivetrains();
    }

    private function makesAndModels()
    {
        collect(json_decode(File::get(resource_path('data/makes.json')), true))
            ->each(function ($entry) {
                $models = $entry['models'] ?? [];
                unset ($entry['models']);
                $make = VehicleMake::query()
                    ->create($entry);
                collect($models)
                    ->each(fn($modelData) => $make->models()->create($modelData));
            });
    }

    private function fuelTypes()
    {
        $types = [
            [
                'name' => 'Bi Fuel',
                'ev_data' => 0,
                'mpg_data' => 1,
            ],
            [
                'name' => 'Diesel Hybrid',
                'ev_data' => 1,
                'mpg_data' => 1,
            ],
            [
                'name' => 'Electric',
                'ev_data' => 1,
                'mpg_data' => 0,
            ],
            [
                'name' => 'Natural Gas',
                'ev_data' => 0,
                'mpg_data' => 1,
            ],
            [
                'name' => 'Petrol Hybrid',
                'ev_data' => 0,
                'mpg_data' => 1,
            ],
            [
                'name' => 'Diesel',
                'ev_data' => 0,
                'mpg_data' => 1,
            ],
            [
                'name' => 'Diesel Plug-in Hybrid',
                'ev_data' => 1,
                'mpg_data' => 1,
            ],
            [
                'name' => 'Hydrogen',
                'ev_data' => 0,
                'mpg_data' => 1,
            ],
            [
                'name' => 'Petrol',
                'ev_data' => 0,
                'mpg_data' => 1,
            ],
            [
                'name' => 'Petrol Plug-in Hybrid',
                'ev_data' => 1,
                'mpg_data' => 1,
            ],
        ];

        FuelType::query()->upsert($types, 'name');
    }

    private function transmissions()
    {
        $types = [
            [
                'name' => 'Automatic',
            ],
            [
                'name' => 'Manual',
            ],
        ];

        TransmissionType::query()->upsert($types, 'name');
    }

    private function bodyStyles()
    {
        $types = [
            [
                'name' => 'Hatchback',
            ],
            [
                'name' => 'Estate',
            ],
            [
                'name' => 'SUV',
            ],
            [
                'name' => 'Saloon',
            ],
            [
                'name' => 'Coupe',
            ],
            [
                'name' => 'Convertible',
            ],
            [
                'name' => 'MPV',
            ],
            [
                'name' => 'Pickup',
            ],
            [
                'name' => 'Hearse',
            ],
            [
                'name' => 'Limousine',
            ],

            [
                "name" => "Box Van"
            ],
            [
                "name" => "Car Derived Van"
            ],
            [
                "name" => "Chassis Cab"
            ],
            [
                "name" => "Combi Van"
            ],
            [
                "name" => "Curtain Side"
            ],
            [
                "name" => "Dropside"
            ],
            [
                "name" => "High Roof Van"
            ],
            [
                "name" => "Luton"
            ],
            [
                "name" => "Minibus"
            ],
            [
                "name" => "Panel Van"
            ],
            [
                "name" => "Pickup"
            ],
            [
                "name" => "Platform"
            ],
            [
                "name" => "SUV"
            ],
            [
                "name" => "Specialist Vehicle"
            ],
            [
                "name" => "Temperature Controlled"
            ],
            [
                "name" => "Tipper"
            ],
            [
                "name" => "Vehicle Transporter"
            ],
            [
                "name" => "Welfare"
            ],
            [
                "name" => "Window Van"
            ]
        ];

        BodyStyleType::query()->upsert($types, 'name');
    }

    private function drivetrains()
    {
        $types = [
            [
                'name' => 'Four Wheel Drive',
            ],
            [
                'name' => 'Front Wheel Drive',
            ],
            [
                'name' => 'Rear Wheel Drive',
            ],
            [
                'name' => 'Belt Drive',
            ],
        ];

        DrivetrainType::query()->upsert($types, 'name');
    }
}
