<?php

namespace Database\Seeders\Global;

use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Permission;
use Mtc\MercuryDataModels\Role;

class PropertyPermissionSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $roles = Role::query()->whereIn('name', ['mtc', 'Administrator'])->get();

        /** @var Permission $model */
        $model = Permission::query()
            ->updateOrCreate([
                'name' => 'manage-properties',
                'guard_name' => 'web'
            ]);
        $roles->each(fn(Role $role) => $role->givePermissionTo([$model]));

        $admin = Role::query()->where('name', 'mtc')->first();
        /** @var Permission $model */
        $model = Permission::query()
            ->updateOrCreate([
                'name' => 'manage-property-categories',
                'guard_name' => 'web'
            ]);
        $admin->givePermissionTo([$model]);
    }
}
