<?php

namespace Database\Seeders\Global;

use App\Master\Models\VehicleMake;
use App\Master\Models\VehicleModel;
use Illuminate\Database\Seeder;

class OpelVanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run(): void
    {
        $make = VehicleMake::query()->where('slug', 'opel')->first();

        if (empty($make)) {
            return;
        }

        collect($this->modelNames())->each(fn($model) => $this->createModel($make->id, $model));
    }

    protected function createModel(int $make_id, string $model_name): void
    {
        VehicleModel::query()->updateOrCreate([
            'make_id' => $make_id,
            'slug' => strtolower($model_name),
            'name' => $model_name,
            'keyloop_id' => strtoupper($model_name),
            'type' => 'lcv',
        ]);
    }

    protected function modelNames(): array
    {
        return [
            'Combo',
            'Movano',
            'Vivaro'
        ];
    }
}
