<?php

namespace Database\Seeders\Global;

use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Permission;
use Mtc\MercuryDataModels\Role;

class EditNewVehiclesRoleSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $roles = Role::query()->whereIn('name', [
            'mtc',
            'Administrator',
            'Manager',
            'Editor',
        ])->get();

        /** @var Permission $model */
        $model = Permission::query()
            ->updateOrCreate([
                'name' => 'edit-new-vehicles',
                'guard_name' => 'web'
            ]);
        $roles->each(fn(Role $role) => $role->givePermissionTo([$model]));
    }
}
