<?php

namespace Database\Factories\Master\Models;

use App\Master\Models\ApiToken;
use App\Master\Models\ApiUser;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Carbon\Carbon;

class ApiTokenFactory extends Factory
{
    protected $model = ApiToken::class;

    public function definition(): array
    {
        $tokenTypes = [
            $this->model::TYPE_OAUTH,
            $this->model::TYPE_PERSISTENT
        ];

        return [
            'api_user_id' => ApiUser::factory(),
            'token_type' => $this->faker->randomElement($tokenTypes),
            'token' => Str::random(42),
            'expires_at' => Carbon::now()->addDay(),
        ];
    }

    public function expired(): Factory
    {
        return $this->state(fn(array $attributes) => [
            'expires_at' => Carbon::now()->subDay(),
        ]);
    }

    /**
     * OAuth token type
     */
    public function oauth(): Factory
    {
        return $this->state(fn(array $attributes) => [
            'token_type' => $this->model::TYPE_OAUTH,
        ]);
    }

    public function persistent(): Factory
    {
        return $this->state(fn(array $attributes) => [
            'token_type' => $this->model::TYPE_PERSISTENT,
        ]);
    }

    public function forUser(ApiUser $user): Factory
    {
        return $this->state(fn(array $attributes) => [
            'api_user_id' => $user->id,
        ]);
    }
}
