<?php

return [
    'kpis' => [
//        'inventory_graph' => \App\Reporting\InventoryGraph::class,
        'enquiries' => \App\Reporting\EnquiryKPI::class,
        'stock' => \App\Reporting\VehiclesInStockKPI::class,
//        'most_popular_brand' => \App\Reporting\MostPopularBrandTile::class,
        'enquiry_count' => \App\Reporting\EnquiryCountTile::class,
        'avg_inventory' => \App\Reporting\AverageInventoryTile::class,
//        'inventory_turnover' => \App\Reporting\InventoryTurnoverRatioTile::class,
//        'customer_satisfaction' => \App\Reporting\CustomerSatisfactionTile::class,
        'avg_vehicle_age' => \App\Reporting\AvgVehicleAgeTile::class,
        'avg_daily_vehicle_views' => \App\Reporting\AvgDailyVehicleViews::class,
        'daily_vehicle_views' => \App\Reporting\DailyVehicleViews::class,
    ],

    'crm_tiles' => [
        'enquiry_count' => \App\Reporting\DailyEnquiryCountTile::class,
        'active_forms' => \App\Reporting\ActiveFormCountTile::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Automated loading
    |--------------------------------------------------------------------------
    |
    | Flags to define whether migrations, routes and task scheduling is done
    | automatically. Disabling them from the package space allows for setting
    | them up in a custom pattern (e.g. multi-tenancy migrations).
    |
    */

    'auto_load_migrations' => false,
    'load_routes' => false,
    'schedule_tasks' => false,

    /*
    |--------------------------------------------------------------------------
    | Data types
    |--------------------------------------------------------------------------
    |
    | Type setting allows specifying what type of report this will be. The
    | intended use is to specify which data model will be used (e.g. Products,
    | Users, Enquiries).
    |
    */
    'types' => [
        'users' => \Mtc\Reports\ReportTypes\UserReport::class,
        'vehicles' => \App\ReportTypes\VehicleReport::class,
        'offers' => \App\ReportTypes\OfferReport::class,
        'enquiries' => \App\ReportTypes\EnquiryReport::class,
    ],

    'report_model' => \App\Models\Report::class,
    'repository' => \App\ReportEngineRepository::class,
    'report_list_resource' => App\Http\Resources\ReportListResource::class,

    'export_formats' => [
        'csv',
        'xlsx',
    ],

    'formats_as_attachments' => [
        'csv' => \App\Exports\ReportExport::class,
        'xlsx' => \App\Exports\ReportExport::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Schedule types
    |--------------------------------------------------------------------------
    |
    | These options are used to specify how the scheduling of reports work.
    | The types will specify when the next report is due based on the
    | given report send-out time.
    |
    */

    'schedule_types' => [
        'daily' => \App\Schedule\Daily::class,
        'weekly' => \App\Schedule\Weekly::class,
        'biweekly' => \App\Schedule\BiWeekly::class,
        'monthly' => \App\Schedule\Monthly::class,
    ],

    'route_middleware' => ['permission:manage-reports'],
];
