<?php

return [
    'auto_load_migrations' => false,
    'load_routes' => false,
    'schedule_tasks' => false,
    'use_transactions' => false,

    'max_element_depth' => 6,

    /*
    |--------------------------------------------------------------------------
    |  Model Bindings
    |--------------------------------------------------------------------------
    |
    | Bindings for data models
    |
    */

    'page_model' => \Mtc\MercuryDataModels\Page::class,
    'version_model' => \Mtc\MercuryDataModels\PageVersion::class,
    'template_model' => \Mtc\MercuryDataModels\Template::class,
    'global_content_model' => \Mtc\MercuryDataModels\GlobalContent::class,
    'element_model' => \Mtc\MercuryDataModels\ContentElement::class,
    'content_model' => \Mtc\MercuryDataModels\Content::class,
    'menu_model' => \Mtc\MercuryDataModels\Menu::class,
    'comment_model' => \Mtc\MercuryDataModels\Comment::class,
    'menu_entry_model' => \Mtc\MercuryDataModels\MenuEntry::class,
    'page_observer' => \App\Observers\PageObserver::class,
    'global_content_observer' => \App\Observers\GlobalContentObserver::class,

    /*
    |--------------------------------------------------------------------------
    | Repository Bindings
    |--------------------------------------------------------------------------
    |
    | Bindings for repository classes that perform actions on data objects
    |
    */

    'page_repository' => \App\PageRepository::class,
    'menu_repository' => \App\MenuRepository::class,
    'element_repository' => App\ElementRepository::class,
    'template_repository' => \App\TemplateRepository::class,


    /*
    |--------------------------------------------------------------------------
    | Resource Bindings
    |--------------------------------------------------------------------------
    |
    | Bindings for resource objects
    |
    */

    'template_list_resource' => \App\Http\Resources\TemplateListResource::class,
    'template_view_resource' => \App\Http\Resources\TemplateViewResource::class,
    'page_list_resource' => \App\Http\Resources\PageListResource::class,
    'page_tree_resource' => \App\Http\Resources\PageTreeResource::class,
    'page_view_resource' => \App\Http\Resources\PageViewResource::class,
    'version_list_resource' => \App\Http\Resources\VersionListResource::class,
    'version_view_resource' => \App\Http\Resources\VersionViewResource::class,
    'global_content_list_resource' => \App\Http\Resources\GlobalContentElementList::class,
    'global_content_view_resource' => \App\Http\Resources\GlobalContentElementView::class,
    'menu_list_resource' => \App\Http\Resources\MenuList::class,
    'menu_view_resource' => \App\Http\Resources\MenuView::class,
    'element_view_resource' => \App\Http\Resources\ContentElementView::class,
    'element_list_resource' => \App\Http\Resources\ContentElementList::class,
    'content_element_block_resource' => \App\Http\Resources\ContentElementBlockResource::class,
    'category_list_resource' => \App\Http\Resources\ContentCategoryList::class,
    'tag_list_resource' => \App\Http\Resources\ContentTagList::class,
    'media_list_resource' => \App\Http\Resources\MediaListResource::class,

    'field_types' => [
        'group' => \Mtc\ContentManager\Fields\Group::class,
        'text' => \Mtc\ContentManager\Fields\Text::class,
        'email' => \App\Fields\Email::class,
        'boolean' => \Mtc\ContentManager\Fields\Boolean::class,
        'datetime' => \Mtc\ContentManager\Fields\DateTime::class,
        'number' => \Mtc\ContentManager\Fields\Number::class,
        'image' => \Mtc\ContentManager\Fields\Image::class,
        'location' => \Mtc\ContentManager\Fields\Location::class,
        'select' => \Mtc\ContentManager\Fields\Select::class,
        'checkbox-list' => \Mtc\ContentManager\Fields\Checkbox::class,
        'editor' => \Mtc\ContentManager\Fields\TextArea::class,
        'form-field' => \App\Fields\Form::class,
        'iframe-field' => \App\Fields\Iframe::class,
    ],

    'page_types' => [
        [
            'value' => 'blog',
            'filter' => 'type-blog',
            'name' => 'Blog',
            'config_key' => 'app-content-blog-enabled',
            'banner_title' => 'Write a new blog post',
            'template_config' => 'app-content-blog-default-template',
            'image' => 'blog.webp',
        ],
        [
            'value' => 'news',
            'filter' => 'type-news',
            'name' => 'News',
            'config_key' => 'app-content-news-enabled',
            'banner_title' => 'Write a news article',
            'template_config' => 'app-content-news-default-template',
            'image' => 'news.webp',
        ],
    ],

    'thumbnail_sizes' => [
        '64x64',
        '332x332',
        '900x600',
        '2560x650'
    ],

    'route_middleware' => [
        'pages' => ['permission:edit-content'],
        'comments' => [],
        'menus' => ['permission:edit-navigation'],
        'elements' => ['permission:edit-navigation'],
        'global-elements' => ['permission:edit-global-content'],
        'templates' => ['permission:edit-templates'],
        'media' => ['permission:edit-media'],
        'tags' => [],
        'categories' => [],
    ],

    'block_categories' => [
        [
            'id' => 'simple',
            'name' => 'Simple Elements',
            'order' => 1,
            'icon' => 'shapes',
        ],
        [
            'id' => 'media',
            'name' => 'Media elements',
            'order' => 2,
            'icon' => 'images',
        ],
        [
            'id' => 'content',
            'name' => 'Content block elements',
            'order' => 3,
            'icon' => 'message-text',
        ],
        [
            'id' => 'crm',
            'name' => 'CRM elements',
            'order' => 3,
            'icon' => 'envelope',
        ],
        [
            'id' => 'navigation',
            'name' => 'Navigation Elements',
            'order' => 4,
        ],
        [
            'id' => 'vehicle',
            'name' => 'Vehicle focused elements',
            'order' => 4,
            'icon' => 'cars',
        ],
        [
            'id' => 'offer',
            'name' => 'Offer focused elements',
            'order' => 5,
            'icon' => 'badge-dollar'
        ],
        [
            'id' => 'automotive',
            'name' => 'Automotive focused elements',
            'order' => 6,
            'icon' => 'garage-car',
        ],
        [
            'id' => 'supporting',
            'name' => 'Supporting Elements & Building blocks',
            'order' => 7,
            'icon' => 'sparkles',
        ],
        [
            'id' => 'custom',
            'name' => 'Custom Elements',
            'order' => 999,
            'icon' => 'gears'
        ],
    ],
];
