<?php

return [
    'auto-trader-service-class' => \App\Modules\Lookup\AutoTraderService::class,
    'drivers' => [
        'cap' => [
            'config' => \App\Modules\Lookup\Config\CapConfig::class,
            'subscriber_id' => env('CAP_SUBSCRIBER_ID', ''),
            'password' => env('CAP_PASSWORD', ''),
        ],
        'beep-beep' => [
            'config' => \App\Modules\Lookup\Config\BeepBeepConfig::class
        ],
        'bca' => [
            'config' => \App\Modules\Lookup\Config\BCAConfig::class,
        ],
        'auto-trader' => [
            'config' => \App\Modules\Lookup\Config\AutoTraderConfig::class,
        ],
        'motor-check' => [
            'config' => App\Modules\Lookup\Config\MotorCheckConfig::class,
        ],
        // AT Connect is the same as autoTrader but uses different key set
        'at-connect' => [
            'config' => \App\Modules\Lookup\Config\AutoTraderConnect::class,
            'api_key' => env('AUTO_TRADER_AI_API_KEY'),
            'api_secret' => env('AUTO_TRADER_AI_API_SECRET'),
            'live' => env('AUTO_TRADER_USE_LIVE_API', true),
        ],
    ],
];
