<?php

namespace App;

use App\Contracts\InteractsWithContentSync;
use Mtc\MercuryDataModels\VehicleTrim;

class VehicleTrimRepository implements InteractsWithContentSync
{
    public function importRecord(array $entry): bool
    {
        $vehicleTrim = VehicleTrim::query()->create($entry);

        return $vehicleTrim->exists;
    }

    public function canBeImported(array $entry): bool
    {
        return !VehicleTrim::query()
            ->where('name', $entry['name'])
            ->exists();
    }

    public function exportToRemote(array $selections): array
    {
        return VehicleTrim::query()->newQuery()
            ->select([
                'name',
                'make_id',
                'active',
                'model_id',
                'fuel_types',
                'colours',
                'transmission_types',
                'mpg',
                'emissions',
                'engine_size',
                'bhp',
                'zero_to_sixty',
                'doors',
                'seats',
                'battery_size',
                'range_miles',
                'battery_charge_time',
                'battery_quick_charge_time',
                'wheelbase',
            ])
            ->whereIn('id', $selections)
            ->get()
            ->toArray();
    }

    public function checkImportEntryValidity(array $dataEntry, array $allEntries): array
    {
        $vehicleTrimExists = VehicleTrim::query()
            ->where('name', $dataEntry['name'])
            ->exists();

        $errors = [];
        if ($vehicleTrimExists) {
            $errors[] = __('validation.import_name_taken', ['name' => $dataEntry['name']]);
        }

        return [
            'data' => $dataEntry,
            'errors' => $errors,
        ];
    }
}
