<?php

namespace App\VehicleSpec\Config;

use App\Facades\Settings;

class AutoTraderConfig
{
    public function enabled(): bool
    {
        return Settings::get('vehicle-spec-providers-autotrader-enabled', false);
    }

    public function apiKey(): string
    {
        return Settings::get('vehicle-spec-providers-autotrader-api_key', '');
    }

    public function apiSecret(): string
    {
        return Settings::get('vehicle-spec-providers-autotrader-api_secret', '');
    }

    public function merchantId(): string
    {
        return Settings::get('vehicle-spec-providers-autotrader-merchant_id', '');
    }

    public function advertiserId(): string
    {
        return Settings::get('vehicle-spec-providers-autotrader-advertiser_id', '');
    }
}
