<?php

namespace App;

use App\Contracts\InteractsWithContentSync;
use Mtc\MercuryDataModels\VehicleAttribute;

class VehicleAttributeRepository implements InteractsWithContentSync
{
    public function importRecord(array $entry): bool
    {
        $vehicleAttribute = VehicleAttribute::query()->create($entry);

        return $vehicleAttribute->exists;
    }

    public function canBeImported(array $entry): bool
    {
        return !VehicleAttribute::query()
            ->where('slug', $entry['slug'])
            ->exists();
    }

    public function exportToRemote(array $selections): array
    {
        return VehicleAttribute::query()
            ->select([
                'name',
                'slug',
                'type',
                'validation',
                'count',
                'data',
                'order'
            ])
            ->whereIn('id', $selections)
            ->get()
            ->toArray();
    }

    public function checkImportEntryValidity(array $dataEntry, array $allEntries): array
    {
        $errors = [];
        if (empty($dataEntry['slug'])) {
            $errors[] = __('validation.import_slug_missing', ['slug' => $dataEntry['slug']]);
        } elseif (VehicleAttribute::query()->where('slug', $dataEntry['slug'])->exists()) {
            $errors[] = __('validation.import_slug_taken', ['slug' => $dataEntry['slug']]);
        }

        return [
            'data' => $dataEntry,
            'errors' => $errors,
        ];
    }
}
