<?php

namespace App\Traits;

use App\Contracts\AbleToSyncContentElements;
use App\GlobalContentRepository;
use App\NewCarRepository;
use App\OfferRepository;
use App\PageRepository;
use App\TemplateRepository;
use Illuminate\Support\Facades\App;
use Mtc\ContentManager\Contracts\Content;
use Mtc\ContentManager\Contracts\GlobalContent;
use Mtc\ContentManager\Contracts\PageModel;
use Mtc\ContentManager\Contracts\Template;
use Mtc\ContentManager\Contracts\TemplateElement;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\NewCarContent;
use Mtc\MercuryDataModels\VehicleOffer;
use Mtc\MercuryDataModels\VehicleOfferContent;

trait TemplateElementSyncProviders
{
    private function getRepository($model): ?AbleToSyncContentElements
    {
        $class = match (true) {
            $model instanceof PageModel,
            $model instanceof Content => PageRepository::class,
            $model instanceof Template,
            $model instanceof TemplateElement => TemplateRepository::class,
            $model instanceof GlobalContent => GlobalContentRepository::class,
            $model instanceof NewCar,
            $model instanceof NewCarContent => NewCarRepository::class,
            $model instanceof VehicleOffer,
            $model instanceof VehicleOfferContent => OfferRepository::class,
            default => null,
        };

        return $class ? App::make($class) : null;
    }
}
